#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/XtlGDH

/*	kalizyl 
	
	(c) 2015, stefan berke (aGPL3)

	Another attempt on the kali set
	http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/

	Looks cool and frametime is not too bad -
	but still uses precission 0.1 for raymarching. (but see EIFFIE_MOD)
	Maybe saves some speed by not coloring the surface.
	
*/

// plot a 2d slice of the distance function
#define PLOT_2D			0
// enable eiffie's modification (https://www.shadertoy.com/view/XtlGRj)
#define EIFFIE_MOD		0


#define KALI_PARAM 		vec3(0.71)
#define LIGHT_COL 		vec3(1.0, 0.8, 0.4)

#if EIFFIE_MOD == 0
    #define FOG_DIST 		5.
    #define FOG_COL 		vec3(0.5, 0.7, 1.0)
    #define CYL_RADIUS 		0.07
    #define NUM_TRACE 		80
    #define MARCH_PRECISION	0.1
#else
    #define FOG_DIST 		2.
    #define FOG_COL 		(vec3(0.5, 0.7, 1.0)/3.)
    #define CYL_RADIUS 		0.009
    #define NUM_TRACE 		40
    #define MARCH_PRECISION	0.9
#endif

#if EIFFIE_MOD == 0
// standard kali set 
// modified to return distance to cylinders and spheres in 'kali-space'
vec2 scene_dist(in vec3 p)
{
	vec2 d = vec2(100.);
	for (int i=0; i<4; ++i)
	{
		p = abs(p) / dot(p, p) - KALI_PARAM;
        // distance to cylinder
		d.x = min(d.x, length(p.xz));	
        if (i < 3)
        {
            vec3 lightpos = vec3(0., 1.+sin(iTime+p.y+float(i)*1.3), 0.);
            // distance to sphere
        	d.y = min(d.y, length(p - lightpos));	
        }
	}
	return d - CYL_RADIUS;
}

#else

// eiffie's mod
vec2 scene_dist(in vec3 pos)
{
    // p.w will track how much we have stretched space
    vec4 p = vec4(pos, 1.);
	vec2 d = vec2(100.);
	for (int i=0; i<4; ++i)
	{
		p = abs(p) / dot(p.xyz, p.xyz) - vec4(KALI_PARAM, 0.);
		d.x = min(d.x, length(p.xz)/p.w); //now we are calcing unstretched distance
        if (i < 3)
        {
            vec3 lightpos = vec3(0., 1.+sin(iTime+p.y+float(i)*1.3), 0.);
            d.y = min(d.y, length(p.xyz - lightpos)/p.w);
        }
	}
	return d - CYL_RADIUS;
}

#endif

vec3 traceRay(in vec3 pos, in vec3 dir)
{
	vec3 p = pos;

	float t = 0., mlightd = 100.;
    
    vec2 d = scene_dist(pos);

	for (int i=0; i<NUM_TRACE; ++i)
	{	
		if (d.x < 0.001 || t >= FOG_DIST) 
			continue;

		p = pos + t * dir;
		vec2 d = scene_dist(p);

        // collect minimum distance to light
		mlightd = min(mlightd, d.y);

		t += d.x * MARCH_PRECISION;		
	}

    // only fog contribution
	vec3 col = FOG_COL * min(1., t/FOG_DIST);

    // plus light glow
    col += LIGHT_COL / (1. + 50.*max(0., mlightd));

	return col;
}

vec3 plot2d(in vec3 pos)
{
	vec2 d = scene_dist(pos);
    // inside?
    float ins = smoothstep(0.01,-0.01, d.x);
    vec3 col = vec3(d.x, ins, 0.);
    
    return col;
}

// camera path
vec3 path(float ti)
{
	float a = ti * 3.14159265 * 2.;

	return vec3(
				1.1 * sin(a),
				0.52 * sin(a*2.),
				1.1 * cos(a) );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy * 2. - 1.;
	uv.x *= iResolution.x / iResolution.y;
	
    vec3 pos, dir;
    mat3 dirm = mat3(vec3(1.,0.,0.), vec3(0.,1.,0.), vec3(0.,0.,1.));
    
    if (iMouse.z < 0.5)
    {
        // camera time
        float ti = iTime / 19.;

        pos = path(ti);

        // camera orientation matrix
        vec3 look;

        // how much to look towards the center [0,1]
        float lookcenter = 0.45 + 0.45 * sin(ti*7.);
    	look = normalize(path(ti + 0.1) - pos);
		look = look + lookcenter * (normalize(-pos) - look);
        vec3 up = normalize(cross(vec3(0., 1., 0.), look));
        vec3 right = normalize(cross(look, up));
        //look = normalize(cross(up, right));
        dirm = mat3(right, up, look);

        dir = dirm * normalize(vec3(uv, 1.5));
    }
    else
    {
        vec2 m = iMouse.xy / iResolution.xy;
        pos = vec3(m.x*2.-1., 0., 3. * m.y);
        dir = normalize(vec3(uv, -1.));
    }
#if PLOT_2D == 0
	fragColor = vec4( traceRay(pos, dir), 1.);	
#else
    fragColor = vec4( plot2d(pos + dirm * vec3(uv,0.)), 1.);	
#endif
}



///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


